#include "TPM2ErrorDecode.h"

//1.1.2	Format-Zero Errors
void formatZeroErrors(CHAR16 ErrorText0[128][216])
{
	int i = 0;
	/*
	for( i = 0; i < 128; i++ ) {
		ErrorText0[i] = AllocateZeroPool(256);
	}
	for( i = 0; i < 128; i++ ) {
		ZeroMem ( ErrorText0[i],  sizeof(ErrorText0[i]) );
	}
	
	for( i = 0; i < 128; i++ ) {
		StrCpy(ErrorText0[i], L"UNKOWN ERROR");
	}
	*/
	for( i = 0; i < 128; i++ ) {
		CopyMem(ErrorText0[i], L"UNKOWN ERROR", 24);
	}
	CopyMem(ErrorText0[0], L"TPM_RC_INITIALIZE: TPM not initialized\0", 78);
	CopyMem(ErrorText0[1], L"TPM_RC_FAILURE: Commands are not being accepted because of a TPM failure1\0", 146);
	CopyMem(ErrorText0[3], L"TPM_RC_SEQUENCE: Improper use of a sequence handle\0", 102);
	CopyMem(ErrorText0[11], L"TPM_RC_PRIVATE: \0", 34);
	CopyMem(ErrorText0[25], L"TPM_RC_HMAC: \0", 28);
	CopyMem(ErrorText0[32], L"TPM_RC_DISABLED: \0", 34);
	CopyMem(ErrorText0[33], L"TPM_RC_EXCLUSIVE: Command failed because audit sequence required exclusivity\0", 154);
	CopyMem(ErrorText0[35], L"TPM_RC_ECC_CURVE: Unsupported curve\0", 72);
	CopyMem(ErrorText0[36], L"TPM_RC_AUTH_TYPE: Authorization handle is not correct for command\0", 132);
	CopyMem(ErrorText0[37], L"TPM_RC_AUTH_MISSING: Command requires an authorization session for handle and it is not present.\0", 194);
	CopyMem(ErrorText0[38], L"TPM_RC_POLICY: Policy Failure In Math Operation or an invalid authPolicy value\0", 158);
	CopyMem(ErrorText0[39], L"TPM_RC_PCR: PCR check fail\0", 54);
	CopyMem(ErrorText0[40], L"TPM_RC_PCR_CHANGED: PCR have changed since checked.\0", 104);
	CopyMem(ErrorText0[44], L"TPM_RC_ECC_POINT: Point is not on the required curve.\0", 108);
	CopyMem(ErrorText0[45], L"TPM_RC_UPGRADE:  The TPM is in field upgrade mode - or for TPM2_FieldUpgradeData(): the TPM is not in field upgrade mode\0", 242);
	CopyMem(ErrorText0[46], L"TPM_RC_TOO_MANY_CONTEXTS: Context ID counter is at maximum.\0", 120);
	CopyMem(ErrorText0[47], L"TPM_RC_AUTH_UNAVAILABLE: authValue or authPolicy is not available for selected entity.\0", 174);
	CopyMem(ErrorText0[48], L"TPM_RC_REBOOT: A _TPM_Init and Startup(CLEAR) is required before the TPM can resume operation.\0", 190);
	CopyMem(ErrorText0[49], L"TPM_RC_UNBALANCED: The protection algorithms (hash and symmetric) are not reasonably balanced. The digest size of the hash must be larger than the key size of the symmetric algorithm.\0", 370);
	CopyMem(ErrorText0[66], L"TPM_RC_COMMAND_SIZE: Command commandSize value is inconsistent with contents of the command buffer; either the size is not the same as the octets loaded by the hardware interface layer or the value is not large enough to hold a command header\0", 488);
	CopyMem(ErrorText0[67], L"TPM_RC_COMMAND_CODE: Command code not supported\0", 98);
	CopyMem(ErrorText0[68], L"TPM_RC_AUTHSIZE: The value of authorzationSize is out of range or the number of octets in the authorization area is greater than required\0", 296);
	CopyMem(ErrorText0[69], L"TPM_RC_AUTH_CONTEXT: Use of an authorization session with a context command\0", 154);
	CopyMem(ErrorText0[70], L"TPM_RC_NV_RANGE: NV offset+size is out of range.\0", 100);
	CopyMem(ErrorText0[71], L"TPM_RC_NV_SIZE: Requested allocation size is larger than allowed.\0", 134);
	CopyMem(ErrorText0[72], L"TPM_RC_NV_LOCKED: NV access locked.\0", 74);
	CopyMem(ErrorText0[73], L"TPM_RC_NV_AUTHORIZATION: NV access authorization fails in command actions (this failure does not affect lockout.action)\0", 242);
	CopyMem(ErrorText0[74], L"TPM_RC_NV_UNINITIALIZED: An NV Index is used before being initialized or the state saved by TPM2_Shutdown(STATE) could not be restored\0", 272);
	CopyMem(ErrorText0[75], L"TPM_RC_NV_SPACE: Insufficient space for NV allocation\0", 110);
	CopyMem(ErrorText0[76], L"TPM_RC_NV_DEFINED: NV index or persistent object already defined\0", 132);
	CopyMem(ErrorText0[80], L"TPM_RC_BAD_CONTEXT: Context in TPM2_ContextLoad() is not valid\0", 128);
	CopyMem(ErrorText0[81], L"TPM_RC_CPHASH: cpHash value already set or not correct for use\0", 128);
	CopyMem(ErrorText0[82], L"TPM_RC_PARENT: Handle for parent is not a valid parent\0", 112);
	CopyMem(ErrorText0[83], L"TPM_RC_NEEDS_TEST: Some function needs testing.\0", 98);
	CopyMem(ErrorText0[84], L"TPM_RC_NO_RESULT: An internal function cannot process the request due to an unspecified problem.\0", 196);
	CopyMem(ErrorText0[85], L"TPM_RC_SENSITIVE: The sensitive area did not unmarshal correctly after decryption\0", 166);
	CopyMem(ErrorText0[127], L"RC_MAX_FM0: Largest format 0 code that is not a warning\0", 114);
	
	return;
}


//1.1.3	Format-One Errors
void formatOneErrors(CHAR16 ErrorText1[39][256])
{
	/*
	int i = 0;
	for( i = 0; i < 39; i++ ) {
		ErrorText1[i] = AllocateZeroPool(256);
	}
	for( i = 0; i < 39; i++ ) {
		ZeroMem ( ErrorText1[i],  sizeof(ErrorText1[i]) );
	}
	*/
	CopyMem(ErrorText1[0], L"UNKOWN ERROR\0", 28);
	
	CopyMem(ErrorText1[1], L"TPM_RC_ASYMMETRIC: Asymmetric algorithm not supported or not correct\0", 140);
	CopyMem(ErrorText1[2], L"TPM_RC_ATTRIBUTES: Inconsistent attributes\0", 88);
	CopyMem(ErrorText1[3], L"TPM_RC_HASH: Hash algorithm not supported or not appropriate\0", 124);
	CopyMem(ErrorText1[4], L"TPM_RC_VALUE: Value is out of range or is not correct for the context\0", 142);
	CopyMem(ErrorText1[5], L"TPM_RC_HIERARCHY: Hierarchy is not enabled or is not correct for the use\0", 148);
	CopyMem(ErrorText1[7], L"TPM_RC_KEY_SIZE: Key size is not supported\0", 88);
	CopyMem(ErrorText1[8], L"TPM_RC_MGF: Mask generation function not supported\0",104);
	CopyMem(ErrorText1[9], L"TPM_RC_MODE: Mode of operation not supported\0", 92);
	CopyMem(ErrorText1[10], L"TPM_RC_TYPE: The type of the value is not appropriate for the use\0", 134);
	CopyMem(ErrorText1[11], L"TPM_RC_HANDLE: The handle is not correct for the use\0", 108);
	CopyMem(ErrorText1[12], L"TPM_RC_KDF: Unsupported key derivation function or function not appropriate for use\0", 170);
	CopyMem(ErrorText1[13], L"TPM_RC_RANGE: Value was out of allowed range.\0", 94);
	CopyMem(ErrorText1[14], L"TPM_RC_AUTH_FAIL: The authorization HMAC check failed and DA counter incremented\0", 164);
	CopyMem(ErrorText1[15], L"TPM_RC_NONCE: Invalid nonce size\0", 68);
	CopyMem(ErrorText1[16], L"TPM_RC_PP: Authorization requires assertion of PP\0", 102);
	CopyMem(ErrorText1[18], L"TPM_RC_SCHEME: Unsupported or incompatible scheme\0", 102);
	CopyMem(ErrorText1[21], L"TPM_RC_SIZE: Structure is the wrong size\0", 84);
	CopyMem(ErrorText1[22], L"TPM_RC_SYMMETRIC: Unsupported symmetric algorithm or key size, or not appropriate for instance\0", 192);
	CopyMem(ErrorText1[23], L"TPM_RC_TAG: Incorrect structure tag\0", 68);
	CopyMem(ErrorText1[24], L"TPM_RC_SELECTOR: Union selector is incorrect\0", 86);
	CopyMem(ErrorText1[26], L"TPM_RC_INSUFFICIENT: The TPM was unable to unmarshal a value because there were not enough octets in the input buffer\0", 238);
	CopyMem(ErrorText1[27], L"TPM_RC_SIGNATURE: The signature is not valid\0", 92);
	CopyMem(ErrorText1[28], L"TPM_RC_KEY: Key fields are not compatible with each other\0", 118);
	CopyMem(ErrorText1[29], L"TPM_RC_POLICY_FAIL: A policy check failed\0", 86);
	CopyMem(ErrorText1[31], L"TPM_RC_INTEGRITY: Integrity check failed\0", 84);
	CopyMem(ErrorText1[32], L"TPM_RC_TICKET: Invalid ticket\0", 62);
	CopyMem(ErrorText1[33], L"TPM_RC_RESERVED_BITS: Reserved bits not set to zero as required\0", 130);
	CopyMem(ErrorText1[34], L"TPM_RC_BAD_AUTH: Authorization failure without DA implications\0", 128);
	CopyMem(ErrorText1[35], L"TPM_RC_EXPIRED: The policy has expired\0", 80);
	CopyMem(ErrorText1[36], L"TPM_RC_POLICY_CC: The commandCode in the policy is not the commandCode of the command\0", 174);
	CopyMem(ErrorText1[37], L"TPM_RC_BINDING:\0", 34);
	CopyMem(ErrorText1[38], L"TPM_RC_CURVE: Curve not supported\0", 70);

	return;
}

//1.1.4	Warnings
void warnings(CHAR16 WarnText[128][256])
{
	int i = 0;
	/*
	for( i = 0; i < 128; i++ ) {
		WarnText[i] = AllocateZeroPool(256);
	}
	for( i = 0; i < 128; i++ ) {
		ZeroMem ( WarnText[i],  sizeof(WarnText[i]) );
	}
	*/
	for( i = 0; i < 128; i++ ) {
		CopyMem(WarnText[i], L"UNKOWN ERROR", 24);
	}
	CopyMem(WarnText[1], L"TPM_RC_CONTEXT_GAP: gap for context ID is too large\0", 106);
	CopyMem(WarnText[2], L"TPM_RC_OBJECT_MEMORY: out of memory for object contexts\0", 114);
	CopyMem(WarnText[3], L"TPM_RC_SESSION_MEMORY: out of memory for session contexts\0", 118);
	CopyMem(WarnText[4], L"TPM_RC_MEMORY: out of shared object/session memory or need space for internal operations\0", 180);
	CopyMem(WarnText[5], L"TPM_RC_SESSION_HANDLES: out of session handles  a session must be flushed before a new session may be created\0", 224);
	CopyMem(WarnText[6], L"TPM_RC_OBJECT_HANDLES: out of object handles  the handle space for objects is depleted and a reboot is required\0", 228);
	CopyMem(WarnText[7], L"TPM_RC_LOCALITY: bad locality\0", 62);
	CopyMem(WarnText[8], L"TPM_RC_YIELDED: TPM has suspended operation on the command; forward progress was made and the command may be retried. See Part 1, Multi-tasking.\0", 296);
	CopyMem(WarnText[9], L"TPM_RC_CANCELLED: the command was canceled\0", 88);
	CopyMem(WarnText[10], L"TPM_RC_TESTING: TPM is performing self-tests\0", 92);
	CopyMem(WarnText[16], L"TPM_RC_REFERENCE_H0: the 1st handle in the handle area references a transient object or session that is not loaded\0", 232);
	CopyMem(WarnText[17], L"TPM_RC_REFERENCE_H1: the 2nd handle in the handle area references a transient object or session that is not loaded\0", 232);
	CopyMem(WarnText[18], L"TPM_RC_REFERENCE_H2: the 3rd handle in the handle area references a transient object or session that is not loaded\0", 232);
	CopyMem(WarnText[19], L"TPM_RC_REFERENCE_H3: the 4th handle in the handle area references a transient object or session that is not loaded\0", 232);
	CopyMem(WarnText[20], L"TPM_RC_REFERENCE_H4: the 5th handle in the handle area references a transient object or session that is not loaded\0", 232);
	CopyMem(WarnText[21], L"TPM_RC_REFERENCE_H5: the 6th handle in the handle area references a transient object or session that is not loaded\0", 232);
	CopyMem(WarnText[22], L"TPM_RC_REFERENCE_H6: the 7th handle in the handle area references a transient object or session that is not loaded\0", 232);
	CopyMem(WarnText[24], L"TPM_RC_REFERENCE_S0: the 1st authorization session handle references a session that is not loaded\0", 198);
	CopyMem(WarnText[25], L"TPM_RC_REFERENCE_S1: the 2nd authorization session handle references a session that is not loaded\0", 198);
	CopyMem(WarnText[26], L"TPM_RC_REFERENCE_S2: the 3rd authorization session handle references a session that is not loaded\0", 198);
	CopyMem(WarnText[27], L"TPM_RC_REFERENCE_S3: the 4th authorization session handle references a session that is not loaded\0", 198);
	CopyMem(WarnText[28], L"TPM_RC_REFERENCE_S4: the 5th session handle references a session that is not loaded\0", 170);
	CopyMem(WarnText[29], L"TPM_RC_REFERENCE_S5: the 6th session handle references a session that is not loaded\0", 170);
	CopyMem(WarnText[30], L"TPM_RC_REFERENCE_S6: the 7th authorization session handle references a session that is not loaded\0", 198);
	CopyMem(WarnText[32], L"TPM_RC_NV_RATE: the TPM is rate-limiting accesses to prevent wear out of NV\0", 154);
	CopyMem(WarnText[33], L"TPM_RC_LOCKOUT: TPM is in DA lockout mode - authorizations subject to DA protection are not allowed at this time\0", 228);
	CopyMem(WarnText[34], L"TPM_RC_RETRY: the TPM was not able to start the command\0", 114);
	CopyMem(WarnText[35], L"TPM_RC_NV_UNAVAILABLE: the command may require writing of NV and NV is not currently accessible\0", 194);
	CopyMem(WarnText[127], L"TPM_RC_NOT_USED: this value is reserved\0", 82);

	return;
}


void decodeTpm20ErrorCode(UINT32 TPM2ReturnCode)
{
	CHAR16 ErrorText0[128][216];
	CHAR16 ErrorText1[39][256];
	CHAR16 WarnText[128][256];

	formatZeroErrors(ErrorText0);
	formatOneErrors(ErrorText1);
	warnings(WarnText);
	if ( TPM2ReturnCode == 0x0 || TPM2ReturnCode == 0x10000 ) {
		Print(L"Success");
		return; 
	} else if ( TPM2ReturnCode == 0x30 ) {
		Print(L"BAD TAG\n");
		return;
	} else if ( (TPM2ReturnCode & BIT_7) == 0 ) {
		//then use FORMAT-ZERO as follows:
		UINT32 errorCode = TPM2ReturnCode & 0x0000007F;
		if ( (TPM2ReturnCode & BIT_8) == 0 ) {
			Print(L"Return Code 0x%x is a TPM1.2 Error Code\n", TPM2ReturnCode);
		}
		if ( (TPM2ReturnCode & BIT_9) != 0 ) {
			Print(L"Reserved Bit 9 is set\n");
		}
		if ( (TPM2ReturnCode & BIT_11) != 0 ) {
			Print(L"Return Code 0x%x indicates WARNING  %s,TPM2ReturnCode\n", WarnText[errorCode]);
		} else if ( (TPM2ReturnCode & BIT_10) != 0 ) {
			Print(L"Return Code 0x%x indicates Vendor Defined Error\n", TPM2ReturnCode );
		} else {
			Print(L"Return Code 0x%x indicates %s\n", TPM2ReturnCode, ErrorText0[ errorCode ] );
		}
	} else {//use FORMAT-ONE as follows:
		UINT32 errorCode = TPM2ReturnCode &  0x0000003F;
		UINT32 paramNumber = (TPM2ReturnCode & 0x00000700) / 0x100;
		CHAR16 errorLocation[10];
		if ( (TPM2ReturnCode & BIT_6) != 0 ) {
			StrCpy(errorLocation, L"Parameter");
		} else if ( (TPM2ReturnCode & BIT_11) != 0 ) {
			StrCpy(errorLocation, L"Session");
		} else {
			StrCpy(errorLocation, L"Handle");
		}
		
		if ( paramNumber == 0 ) {
			Print(L"Return Code 0x%x indicates the command has the following error: \n  %s \n", TPM2ReturnCode, ErrorText1[errorCode] );
		} else { 
			Print(L"Return Code 0x%x indicates %s %d has the following error: \n  %s \n", TPM2ReturnCode, errorLocation, paramNumber, ErrorText1[errorCode] );
		}
	}
	
	return;
}






